<h1 align="center">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://www.linkace.org/images/linkace-social-dark-transparent.png">
    <img src="https://www.linkace.org/images/linkace-social.jpg" alt="Linkace">
  </picture>
</h1>

<p align="center"><b>Your self-hosted tool for effortlessly archiving, organizing, and sharing your favorite web links.</b></p>

<p align="center">
  <a href="https://mastodon.social/@linkace"><img src="https://img.shields.io/badge/%40linkace%40mastodon.social-6364ff" alt="Follow LinkAce on Mastodon"></a>
  <a href="https://x.com/LinkAceApp"><img src="https://img.shields.io/badge/X.com%2FLinkAceApp-black" alt="Follow LinkAce on X.com"></a>
  <a href="https://github.com/Kovah/LinkAce/releases"><img src="https://img.shields.io/github/v/release/kovah/linkace?label=Latest%20Release" alt="Latest Release"></a>
  <a href="https://opensource.org/licenses/GPL-3.0"><img src="https://img.shields.io/github/license/kovah/linkace.svg" alt="License"></a>
</p>
<p>&nbsp;</p>


### Contents

* [About LinkAce](#about-linkace)
* [Setup](#gear-setup)
* [Support](#bulb-support-for-linkace)
* [Contribution](#construction-contribution)


&nbsp;


### About LinkAce

![Preview Screenshot](https://www.linkace.org/images/preview/dashboard-preview_2.0.jpg)

LinkAce ia a powerful, self-hosted solution for managing your personal link archive. Save articles for later reading, bookmark useful tools, and preserve important web content long-term – all in one place. With a clean, user-friendly interface, you can easily categorize and retrieve your links, and even share collections with friends, family, or coworkers. LinkAce isn't meant to replace your browser bookmarks, but rather to provide you with a robust, personalized database for curating and managing your online discoveries. Whether you're a professional, a researcher or simply an avid internet user, you'll find this tool invaluable for organizing your web resources efficiently and effectively.

👉 [**Try the Demo**](https://demo.linkace.org)


#### Feature Highlights

* Organize bookmarks with the help of lists and tags.
* Multi-user support with internal sharing of links, lists or tags.
* OAuth and OIDC are supported for SSO login to LinkAce.
* Automated link monitoring informs you when any links become unavailable or were moved.
* Automated archiving of saved sites via the [Internet Archive](https://web.archive.org/).
* A full REST API offers access to all features of LinkAce from other apps and services.
* LinkAce is also [available on Zapier](https://zapier.com/apps/linkace/integrations) and integrates with over 2500+ applications.
* An advanced search including different filters and ordering.
* A bookmarklet to quickly save links from any browser.
* Save links with automatic title and description generation.
* LinkAce ships with a light and dark theme, that can be toggled or changes automatically.
* Links can be private or public, so friends or internet strangers may see your collection.
* Both private and public lists of links are accessible via RSS feeds.
* Import and export of bookmarks from and to HTML.
* Support for complete database and application backups to any AWS S3-compatible storage.

More screenshots of the app and further details about the features can be found on the [LinkAce Website](https://www.linkace.org/).


&nbsp;


### :gear: Setup

LinkAce provides multiple ways of installing it on your server. The complete documentation for all installation methods can be found [**in the wiki**](https://www.linkace.org/docs/v2/setup/).

* [Setup with Docker](https://www.linkace.org/docs/v2/setup/setup-with-docker/)
* [Setup without Docker](https://www.linkace.org/docs/v2/setup/setup-with-php/)
* [One-Click Deployment to the Cloud](https://www.linkace.org/docs/v2/setup/one-click-deploy/)
* [Setup with Kubernetes](https://www.linkace.org/docs/v2/setup/setup-to-k8s/) (Beta)
* [Official managed Hosting](https://hosting.linkace.org) (_Beta Waitlist_)

&nbsp;

> **LinkAce 2.0 was just released!** This is a big upgrade to the application. Please read the [upgrade guide](https://www.linkace.org/docs/v2/upgrade/from-v1/) if you are still using LinkAce 1 and want to use version 2.

&nbsp;


### :bulb: Support for LinkAce

I built LinkAce to solve my own problem, and I now offer my solution and code without charging any money. I spent a lot of my free time building this application, so I won't offer any *free* personal support, customization or installation help. If you need help please visit the [community discussions](https://github.com/Kovah/LinkAce/discussions) and post your issue there.

:star: You can get personal and dedicated support by **becoming a supporter on [Open Collective](https://opencollective.com/linkace), [Patreon](https://www.patreon.com/Kovah) or [Github](https://github.com/sponsors/Kovah)**.

#### Our Supporters on Open Collective

<a href="https://opencollective.com/linkace"><img src="https://opencollective.com/linkace/individuals.svg?width=890"></a>


### Documentation and Community

Details about all features and advanced configuration can be found in the [**project documentation**](https://www.linkace.org/docs/v2).  
Additionally, you may visit the [community discussions](https://github.com/Kovah/LinkAce/discussions) to share your ideas, talk with other users or find help for specific problems.


&nbsp;


### :construction: Contribution

[![Translations](https://img.shields.io/badge/Translations-Crowdin-2b303d)](https://crowdin.com/project/linkace) [![Codacy Badge](https://app.codacy.com/project/badge/Grade/c32c698ee97b4af2b04d7b7f45f39bae)](https://app.codacy.com/gh/Kovah/LinkAce/dashboard?utm_source=gh&utm_medium=referral&utm_content=&utm_campaign=Badge_grade) ![GitHub branch check runs](https://img.shields.io/github/check-runs/kovah/linkace/2.x?label=Checks)

Please consult the [**contribution guidelines**](CONTRIBUTING.md) to start working on LinkAce.


&nbsp;


Thanks go to these wonderful people for their contributions:

[![List of contributors](https://contrib.rocks/image?repo=kovah/linkace)](https://github.com/Kovah/LinkAce/graphs/contributors)


&nbsp;


LinkAce is a project by [Kevin Woblick](https://woblick.dev) and [Contributors](https://github.com/Kovah/LinkAce/graphs/contributors)
